
function main(image) {
    
    var doc = NSApplication. sharedApplication(). currentDocument();
    var data = doc.dataOfType_error_( "public.png"  ,null);
    
    var bitmap = NSBitmapImageRep.alloc().initWithData(data);
    var extent = NSMakeRect(0, 0, bitmap. pixelsWide(), bitmap. pixelsHigh());
    
    var xOffset = 5;
    var yOffset = 35;
    var curveHeight = 15;
    var imageYOffset = 10;
    var whiteBorderWidth = 4;
    var doubleBorderWidth = whiteBorderWidth * 2;
    
    var newSize = NSMakeSize(extent.size.width + (whiteBorderWidth * 2),
    extent.size.height + imageYOffset + (whiteBorderWidth * 2));
    
    var newImage = FMDrawContext.drawContextWithSize_( newSize);
    
    newImage. lockFocus();
    
    NSGraphicsContext. currentContext(). saveGraphicsState();
    
    var shadow = NSShadow. alloc(). init();
    shadow.setShadowColor_( NSColor. blackColor().colorWithAlphaComponent_( .6));
    
    var shadowOffset = NSMakeSize(0, -(yOffset + 5));
    shadow.setShadowOffset_( shadowOffset);
    shadow.setShadowBlurRadius_( 5);
    shadow.set()
    
    
    bezierPath = NSBezierPath.bezierPath();
    
    bezierPath.moveToPoint_( NSMakePoint(xOffset, 40 + yOffset));
    bezierPath.lineToPoint_( NSMakePoint(extent.size.width - (xOffset) + doubleBorderWidth, 40 + yOffset));
    bezierPath.lineToPoint_( NSMakePoint(extent.size.width - (xOffset) + doubleBorderWidth, 10 + yOffset));
    
    bezierPath.curveToPoint_controlPoint1_controlPoint2_( NSMakePoint (newSize.width / 2, curveHeight + yOffset)
    ,NSMakePoint (extent.size.width - (xOffset), 10 + yOffset)
    ,NSMakePoint(newSize.width *.75, curveHeight + yOffset));
    
    bezierPath.curveToPoint_controlPoint1_controlPoint2_( NSMakePoint (xOffset, 10 + yOffset)
    ,NSMakePoint (newSize.width *.25, curveHeight + yOffset)
    ,NSMakePoint(xOffset, 10 + yOffset));
    
    bezierPath. fill();
    
    
    NSGraphicsContext. currentContext(). restoreGraphicsState();
    
    
    NSColor. whiteColor(). set();
    NSBezierPath.bezierPathWithRect_( NSMakeRect(0, imageYOffset, newSize.width, extent.size.height + whiteBorderWidth * 2)). fill();
    
    
    NSColor. lightGrayColor(). set();
    NSBezierPath.bezierPathWithRect_( NSMakeRect(.5, imageYOffset + .5 , newSize.width - 1, (extent.size.height - 1) + (whiteBorderWidth * 2))). stroke();
    
    bitmap.drawInRect_(NSMakeRect(whiteBorderWidth, imageYOffset + whiteBorderWidth, bitmap.pixelsWide(), bitmap.pixelsHigh()));
    
    newImage. unlockFocus();
    
    var doc2 = NSDocumentController.sharedDocumentController().makeUntitledDocumentWithCIImage(newImage.CIImage());
}
